/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.sdgraph.AbstractSdgNode;
import cz.insophy.inplan.sdgraph.EdgeMaker;
import cz.insophy.inplan.sdgraph.SdgEdgeImpl;
import cz.insophy.inplan.sdgraph.SdgEsaNode;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraphBuilder;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.util.Tuple;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UnplannedEdgeMaker
extends EdgeMaker {
    private final StoreSchedule externalSs;
    private final StoreSchedule possibleSs;
    private final StoreSchedule actualSs;
    private final Iterable<ExternalEdge> externalEdges;
    private final Map<Material, EsaPairing> esaPairingMap;
    private int orderKey;

    UnplannedEdgeMaker(StoreDependencyGraphBuilder b, Iterable<ExternalEdge> externalEdges) {
        super(b);
        this.externalEdges = externalEdges;
        this.externalSs = this.superplan.getPlan().getStoreSchedule(StoreType.EXTERNAL);
        this.possibleSs = this.superplan.getPlan().getStoreSchedule(StoreType.INPLAN_POSSIBLE);
        this.actualSs = this.superplan.getPlan().getStoreSchedule(StoreType.INPLAN_ACTUAL);
        this.esaPairingMap = Maps.newIdentityHashMap();
    }

    @Override
    protected void makeEdges() {
        for (ExternalEdge ee : this.externalEdges) {
            Tuple<SdgNode, StoreActivity> t;
            StoreActivity dstSa;
            SdgNode dstNode;
            if (ee.destination == null) {
                dstNode = this.b.getMaterialNode(ee.mat);
                dstSa = null;
            } else {
                t = this.getNode(ee.destination, ee.mat, false);
                dstNode = t.getFirst();
                dstSa = t.getSecond();
            }
            if (ee.source == null) {
                for (Tuple tuple : this.getEsaNodes(ee.mat, ee.qty)) {
                    SdgEsaNode srcNode = (SdgEsaNode)tuple.getFirst();
                    double qty = (Double)tuple.getSecond();
                    this.b.addEdge(new SdgEdgeImpl(this.orderKey++, srcNode, dstNode, srcNode.getEsa(), dstSa, qty));
                }
                continue;
            }
            t = this.getNode(ee.source, ee.mat, true);
            SdgNode sdgNode = t.getFirst();
            StoreActivity srcSa = t.getSecond();
            this.b.addEdge(new SdgEdgeImpl(this.orderKey++, sdgNode, dstNode, srcSa, dstSa, ee.qty));
        }
    }

    protected Tuple<SdgNode, StoreActivity> getNode(@Nonnull Object obj, Material mat, boolean pos) {
        StoreActivity nodeSa;
        AbstractSdgNode node;
        if (obj instanceof GeneralizedActionRequest) {
            GeneralizedActionRequest gar = (GeneralizedActionRequest)obj;
            node = this.b.getGarNode(gar);
            nodeSa = this.findStoreActivity(this.possibleSs, mat, sa -> sa.getOriginator() == gar && sa.getQty() < 0.0 ^ pos);
        } else if (obj instanceof GeneralizedOrderRequest) {
            GeneralizedOrderRequest gor = (GeneralizedOrderRequest)obj;
            node = this.b.getGorNode(gor);
            nodeSa = this.findStoreActivity(this.possibleSs, mat, sa -> {
                Object orig = sa.getOriginator();
                return orig instanceof ProductionTreeNode && ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)orig) == gor && sa.getQty() < 0.0 ^ pos;
            });
        } else if (obj instanceof CustomerRequest) {
            CustomerRequest cr = (CustomerRequest)obj;
            node = this.b.getCrNode(cr);
            nodeSa = this.findStoreActivity(this.actualSs, mat, sa -> sa.getOriginator() == cr);
        } else if (obj instanceof SupplyRequest) {
            SupplyRequest sr = (SupplyRequest)obj;
            node = this.b.getSrNode(sr);
            nodeSa = this.findStoreActivity(this.actualSs, mat, sa -> sa.getOriginator() == sr);
        } else {
            throw new IllegalArgumentException("Unexpected node type " + obj.getClass());
        }
        return Tuple.create(node, nodeSa);
    }

    private StoreActivity findStoreActivity(StoreSchedule ss, Material mat, Predicate<StoreActivity> predicate) {
        return ss.getActivities(mat).stream().filter(predicate).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find matching activity for material " + mat));
    }

    private Iterable<Tuple<SdgEsaNode, Double>> getEsaNodes(Material mat, double qty) {
        EsaPairing esaPairing = this.esaPairingMap.computeIfAbsent(mat, x$0 -> new EsaPairing((Material)x$0));
        return Streams.stream(esaPairing.pair(qty)).map(t -> Tuple.create(this.b.getEsaNode((ExternalStoreActivity)t.getFirst()), (Double)t.getSecond())).collect(Collectors.toList());
    }

    public static class ExternalEdge {
        private final Object source;
        @Nullable
        private final Object destination;
        @Nonnull
        private final Material mat;
        private final double qty;

        public ExternalEdge(@Nullable Object source, @Nullable Object destination, @Nonnull Material mat, double qty) {
            this.source = source;
            this.destination = destination;
            this.mat = mat;
            this.qty = qty;
        }
    }

    private class EsaPairing {
        private final Iterator<StoreActivity> acts;
        double unpairedQty;
        ExternalStoreActivity sa;

        EsaPairing(Material mat) {
            this.acts = UnplannedEdgeMaker.this.externalSs.getActivities(mat).iterator();
        }

        public Iterator<Tuple<ExternalStoreActivity, Double>> pair(final double qty) {
            return new AbstractIterator<Tuple<ExternalStoreActivity, Double>>(){
                double remainingQty;
                {
                    this.remainingQty = qty;
                }

                @Override
                protected Tuple<ExternalStoreActivity, Double> computeNext() {
                    if (this.remainingQty <= 1.0E-7) {
                        return (Tuple)this.endOfData();
                    }
                    if (EsaPairing.this.unpairedQty <= 1.0E-7) {
                        if (EsaPairing.this.acts.hasNext()) {
                            EsaPairing.this.sa = (ExternalStoreActivity)EsaPairing.this.acts.next();
                            Preconditions.checkState(EsaPairing.this.sa.getQty() > 0.0);
                            EsaPairing.this.unpairedQty += EsaPairing.this.sa.getQty();
                        } else {
                            return (Tuple)this.endOfData();
                        }
                    }
                    double pairedQty = Math.min(this.remainingQty, EsaPairing.this.unpairedQty);
                    this.remainingQty -= pairedQty;
                    EsaPairing.this.unpairedQty -= pairedQty;
                    return Tuple.create(EsaPairing.this.sa, pairedQty);
                }
            };
        }
    }
}

